/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
CSkeleton cskel;
/******************************************************************************/
void InitPre()
{
   App.name="Animation";
   App.flag=APP_MS_EXCLUSIVE;
   PakAdd("../data/engine.pak");
}
/******************************************************************************/
Bool Init()
{
   Text_ds.color =BLACK;
   Text_ds.shadow=0;

   Cam.dist=2;
   Cam.yaw =PI;

   cskel.create("../data/obj/chr/skeleton/0.skel",1.7); // create controlled skeleton from skel file, with 1.7 meter height
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   CamHandle(0.1,10,CAMH_ROT|CAMH_ZOOM);

   // set animations
   {   
      cskel.clear();     // clear controlled skeleton animation
      if(Kb.b(KB_SPACE)) // when space pressed
      {
         cskel.animate("../data/anim/walk.anim",Tm.time()); // animate with "walk" animation and current time position
      }
      cskel.updateMatrix(MatrixIdentity); // update controlled skeleton animation matrixes
      cskel.updateVelocities(          ); // update controlled skeleton bone velocities (this is needed for Motion Blur effect)
   }

   return true;
}
/******************************************************************************/
void Draw()
{
   D.clear(WHITE);

   // render
   {
      LightDir(1,Vec(0,0,-1)).set(); // set light

      Meshs("../data/obj/chr/skeleton/0.mesh")->draw(cskel); // get mesh from cache and render it with controlled skeleton matrixes

      if(Kb.ctrl) // when control pressed
      {
         MatrixSet();     // restore default matrix
         cskel.draw(RED); // draw controlled skeleton
      }
   }

   D.text(0,0.8,"Hold space to animate");
}
/******************************************************************************/
